#Author: Dr.R.Parvathi,Professor, School of Computing Science & Engineering, VIT Chennai
#Ex3 - Visualization of Association Rules - Apriori Algorithm
# R version 3.6.2 (2019-12-12)
#RStudio version 1.2.1335
rm(list=ls())

library(arulesViz)
# 1. Load the Groceries dataset and apply apriori algorithm with support as 0.005 and confidence as 0.5 the data.
data(Groceries)
rules <- apriori(Groceries, parameter=list(support=0.005, confidence=0.5))
rules
# 2. Plot the rules generated by the apriori algorithm
plot(rules)
# try sel <- plot(rules, interactive=TRUE)

# 3. Group the rules based on order
plot(rules, shading="order", control=list(main = "Two-key plot", 
                                          col=rainbow(5)))
# 4. 2D matrix with shading. The following techniques work better with fewer rules for better visualization
subrules <- subset(rules, lift>2.5)
subrules
plot(subrules, method="matrix", measure="lift")
# 5. 3D Matrix visulization 
plot(subrules, method="matrix3D", measure="lift")

# 6.. grouped matrix plot
plot(rules, method="grouped")
plot(rules, method = "grouped", control = list(k = 50))
#7. Visualization of rules using Graphs
subrules2 <- sample(rules, 10)
plot(subrules2, method="graph")
plot(subrules2, method="graph", control=list(layout=igraph::in_circle()))
plot(subrules2, method="graph", control=list(
  layout=igraph::with_graphopt(spring.const=5, mass=50)))
plot(subrules2, method="graph", control=list(type="itemsets"))
# 8. Visualization of rules using parallel coordinates
plot(subrules2, method = "paracoord")
plot(subrules2, method = "paracoord", control = list(reorder = TRUE))
# 9. Visualization of one rule using doubledecker plot
oneRule <- sample(rules, 1)
inspect(oneRule)
plot(oneRule, method = "doubledecker", data = Groceries)
#10. Itemset Visualization as Graph
itemsets <- eclat(Groceries, parameter = list(support = 0.02, minlen=2))
# 11. Itemset Graph visualization with various support values
plot(itemsets)
plot(itemsets, method="graph")
itemsets <- eclat(Groceries, parameter = list(support = 0.03, minlen=2))
plot(itemsets, method="graph")
itemsets <- eclat(Groceries, parameter = list(support = 0.04, minlen=2))
plot(itemsets, method="graph")
# 12. Itemset visualization using parallel coordinates
plot(itemsets, method="paracoord", control=list(alpha=.5, reorder=TRUE))
# 13. Add more quality measures to the scatterplot
quality(itemsets) <- interestMeasure(itemsets, trans=Groceries)
head(quality(itemsets))
plot(itemsets, measure=c("support", "allConfidence"), shading="lift",control = list(col=rainbow(7)))
# 14. Visulization of rules with Left hand side value as whole milk
rules<-apriori(data=Groceries, parameter=list(supp=0.001,conf = 0.15,minlen=2), 
               appearance = list(default="rhs",lhs="whole milk"),
               control = list(verbose=F))
rules<-sort(rules, decreasing=TRUE,by="confidence")
inspect(rules[1:5])
library(arulesViz)
plot(rules,method="graph",engine = 'default',shading=NA)
# 15. Visualization of rules with Right Hand Side value as Butter
rules<-apriori(data=Groceries, parameter=list(supp=0.005,conf = 0.08), 
               appearance = list(default="lhs",rhs="butter"),
               control = list(verbose=F))
rules<-sort(rules, decreasing=TRUE,by="confidence")
inspect(rules[1:5])
library(arulesViz)
plot(rules,method="graph",engine = 'default',shading=NA)
# 16. Create an item frequency plot for top 20 items
itemFrequencyPlot(Groceries,topN=20,type="absolute")

