#Author: Dr.Pattabiraman.V, Professor, School of Computing Science & Engineering, VIT Chennai
#Ex3 - Construction and Visualization of Network from the data files using Igraph
#R version 3.6.2 (2019-12-12)
#RStudio version 1.2.1335

nodes <- read.csv("Dataset1-Media-Example-NODES.csv")
links <- read.csv("Dataset1-Media-Example-EDGES.csv")


head(nodes)
head(links)
nrow(nodes); length(unique(nodes$id))
nrow(links); nrow(unique(links[,c("from", "to")]))


links <- aggregate(links[,3], links[,-3], sum)
links <- links[order(links$from, links$to),]
colnames(links)[4] <- "weight"
rownames(links) <- NULL


library(igraph)
net <- graph_from_data_frame(d=links, vertices=nodes, directed=T) 
class(net)
net

E(net)       # The edges of the "net" object
V(net)       # The vertices of the "net" object
E(net)$type  # Edge attribute "type"
V(net)$media # Vertex attribute "media"

plot(net, edge.arrow.size=.4,vertex.label=NA)

net <- simplify(net, remove.multiple = F, remove.loops = T) 


as_edgelist(net, names=T)
as_adjacency_matrix(net, attr="weight")


as_data_frame(net, what="edges")
as_data_frame(net, what="vertices")


#Matrix
nodes2 <- read.csv("Dataset2-Media-User-Example-NODES.csv", header=T, as.is=T)
links2 <- read.csv("Dataset2-Media-User-Example-EDGES.csv", header=T, row.names=1)

head(nodes2)
head(links2)

links2 <- as.matrix(links2)
dim(links2)
dim(nodes2)


head(nodes2)
head(links2)


net2 <- graph_from_incidence_matrix(links2)
table(V(net2)$type)

net2.bp <- bipartite.projection(net2)

as_incidence_matrix(net2) %*% t(as_incidence_matrix(net2))
t(as_incidence_matrix(net2)) %*% as_incidence_matrix(net2)

plot(net2.bp$proj1, vertex.label.color="black",vertex.label.cex=0.8, vertex.label.dist=1,
     vertex.size=15, vertex.label=nodes2$media[!is.na(nodes2$media.type)])



