#Author: Dr.Pattabiraman.V, Professor, School of Computing Science & Engineering, VIT Chennai
#Ex2 - Visualization of Different Graph and Graph Models
#R version 3.6.2 (2019-12-12)
#RStudio version 1.2.1335
library(igraph)
#Empty Graph
eg <- make_empty_graph(50)
plot(eg, vertex.size=15, vertex.label=NA)

#Full Grapph
fg <- make_full_graph(40)
plot(fg, vertex.size=10, vertex.label=NA)

#Star graph
fg <- make_star(40)
plot(fg, vertex.size=10, vertex.label=NA)


#Tree graph
tr <- make_tree(40, children = 2, mode = "undirected")
plot(tr, vertex.size=10, vertex.label=NA) 

#Ring graph
rn <- make_ring(40)
plot(rn, vertex.size=10, vertex.label=NA)

#Erdos-Renyi graph
er <- sample_gnm(n=120, m=45) 
plot(er, vertex.size=6, vertex.label=NA)  

#Watts-Strogatz small-world model
sw <- sample_smallworld(dim=2, size=10, nei=1, p=0.1)
plot(sw, vertex.size=6, vertex.label=NA, layout=layout_in_circle)

#Barabasi-Albert preferential attachment model for scale-free graphs
ba <-  sample_pa(n=150, power=1, m=1,  directed=F)
plot(ba, vertex.size=6, vertex.label=NA)


