#Author: Dr.Pattabiraman.V, Professor, School of Computing Science & Engineering, VIT Chennai
#Ex1- Creation of Network with Edge,Node along with Network Attributes and Visualization of Network using igraph
#R version 3.6.2 (2019-12-12)
#RStudio version 1.2.1335
library(igraph)
g4 <- graph( c('Susann', 'Jeanette', 'Harrison', 'Myron', 'Julie', 'Colten', 'Brandyn', 'Leland', 'Catherine', 'Tracy', 'Bee', 'Maureen', 'Annika', 'Hans', 'Spenser', 'Angelo', 'Blanche', 'Stanford', 'Hope', 'Catherine', 'Almira', 'Thomas', 'Henry', 'Ralph', 'Louvenia', 'German', 'Lura', 'Wilma', 'Lauretta', 'Maudie', 'Martha', 'Henry', 'Loyd', 'Mayra', 'Noelle', 'Fabian', 'Ira', 'Zenobia', 'Noelle', 'Natalie', 'Brooke', 'German', 'Lauretta', 'Zenobia', 'Hallie', 'Braxton', 'Lorraine', 'Alicia', 'Allie', 'Jaylon', 'Myrna', 'Darrel', 'Lura', 'Hermon', 'Wyatt', 'Raoul', 'Althea', 'Laurel', 'Leola', 'Darrel', 'Giles', 'Merritt', 'Angelo', 'Kendrick', 'Travis', 'Henry', 'Owen', 'Almira', 'Michelle', 'Lou', 'Stephan', 'Leola', 'Wyatt', 'Allie', 'Eli', 'Brandyn', 'Mayra', 'Chin', 'Clarance', 'Marlee', 'Glenn', 'Reid', 'Glenn', 'Jerrold', 'Dale', 'Helena', 'Alvie', 'Elden', 'Chaim', 'Merritt', 'Augustine', 'Curtiss', 'Alvie', 'Allie', 'Pollie', 'Catherine', 'Angelita', 'Glenn', 'Allie', 'Braden', 'Manford', 'Raoul', 'Dwight', 'Pollie', 'Zona', 'Reggie', 'Dominic', 'Amy', 'Santos', 'Faron', 'Leslie', 'Etha', 'Maureen', 'Juanita', 'Gust', 'Noelle', 'Darrel', 'Darin', 'Faron', 'Zona', 'Myron', 'Hans', 'German', 'Elden', 'Mayra', 'Merritt', 'Myron', 'Gerald', 'Andrea', 'German', 'Angelita', 'Giles', 'Reggie', 'Wyatt', 'Alvie', 'Darrel', 'Jarrett', 'Newell', 'Brandyn', 'Eloisa', 'Santos', 'Lou', 'Quintin', 'Zechariah', 'Leola', 'Anthony', 'Eliga', 'Gust', 'Obie', 'Obie', 'Brandyn', 'Brooke', 'Dominic', 'Jacoby', 'Maureen', 'Hardie', 'Noelle', 'Braxton', 'Noelle', 'Leola', 'Marlee', 'Helena', 'Ira', 'Kermit', 'Wilda', 'Eli', 'Chance', 'Hardie', 'Andrea', 'Johnnie', 'Lauretta', 'Tracy', 'Kathryn', 'Spenser', 'Lou', 'Dana', 'Dominic', 'Rachelle', 'Glenn', 'Darrel', 'Deidra', 'Orpha', 'Hermon', 'Rosalind', 'Hans', 'Curtis', 'Josue', 'Wyatt', 'Agatha', 'Wyatt', 'Chance', 'Glenn', 'Kendrick', 'Brooke', 'Hollie', 'Beverly', 'Katarina', 'Josue', 'Leslie', 'Colten', 'Mayra', 'Darin', 'Hermon', 'Myron', 'Alicia', 'Leila', 'Kermit', 'Lamar', 'Dana', 'Johnnie', 'Althea', 'Judson', 'Colten', 'Hope', 'Gust', 'Clarance', 'Leland', 'Matthew', 'Lorraine', 'Althea', 'Colten', 'Jewel', 'Leila', 'Eli', 'Zenobia', 'German', 'Jaylon', 'Henry', 'Michelle', 'Johnie', 'Judson', 'Johnnie', 'Leslie', 'Wyatt', 'Lou', 'Maureen', 'Jacoby', 'Noelle', 'Johnnie', 'Alvie', 'Leila', 'Myron', 'Wilda', 'Brandyn', 'Kendrick', 'Gerald', 'Tyson', 'Jacoby', 'Ari', 'Theo', 'Harrison', 'Carmen', 'Leonard', 'Braden', 'Desi', 'Zona', 'Maureen', 'Ralph', 'Thomas', 'Myron', 'Austin', 'Leola', 'Loyd', 'Quintin', 'Lorraine', 'Glenn', 'Merritt', 'Janet', 'Myron', 'Alicia', 'Maureen', 'Leslie', 'Carla', 'Vicky', 'Harley', 'Leslie', 'Hannah', 'Gust', 'Andrea', 'Giles', 'Wilma', 'Henry', 'Hermon', 'Stefani', 'Henry', 'Harley', 'Noelle', 'Kermit', 'Laurel', 'Hermon', 'Sebastian', 'Andrea', 'Eliga', 'Sigmund', 'Darrel', 'Noelle', 'Urban', 'Almira', 'Noelle', 'Dwight', 'Beverly', 'Wyatt', 'Juanita', 'Reid', 'Kermit', 'Myrna', 'Pollie', 'Hope', 'Leola', 'Leslie', 'Jacoby', 'Pollie', 'Tiffany', 'Gust', 'Leland', 'Eliga', 'Lamar', 'Ira', 'Dale', 'Noelle', 'Jarrett', 'Zenobia', 'Orpha', 'Glenn', 'Amy', 'Hermon', 'Myrna', 'Brandyn', 'Nell', 'Leslie', 'Edd', 'Lura', 'Kendrick', 'Obie', 'Augustine', 'Zona', 'Glenn', 'Dominic', 'Jennifer', 'Rachelle', 'Faron', 'Darrel', 'Pollie', 'Almira', 'Glenn', 'Wilma', 'Angus', 'Leila', 'Sherri'))

plot(g4, edge.arrow.size=.5, vertex.color="gold", vertex.size=5, 
     
     vertex.frame.color="gray", vertex.label.color="black", 
     
     vertex.label.cex=0.8, vertex.label.dist=2, edge.curved=0.2) 



V(g4)$name
V(g4)$part <- c('teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'student', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'teacher', 'student', 'student', 'student')

E(g4)$type <- "knows" 

g4 <- set.edge.attribute(g4, "weight", value=runif(ecount(g4)))
get.edge.attribute(g4, "weight")

edge_attr(g4)
vertex_attr(g4)


plot(g4, edge.arrow.size=.2, vertex.label.color="black", vertex.label.dist=0.1,vertex.size=6,vertex.label.cex=0.8,
     
     vertex.color=c( "yellow", "skyblue")[1+(V(g4)$part=="student")] )


plot(g4, edge.arrow.size=.5, vertex.label.color="black", vertex.label.dist=1.5,vertex.size=5, 
     vertex.color=c( "yellow", "skyblue")[1+(V(g4)$part=="student")],
     vertex.shape=c( "circle", "square")[1+(V(g4)$part=="student")] 
)  

layouts <- grep("^layout_", ls("package:igraph"), value=TRUE)[-1]
layouts <- layouts[!grepl("bipartite|merge|norm|sugiyama|tree", layouts)]
#par(mfrow=c(3,5), mar=c(1,1,1,1))
for (layout in layouts) {
  print(layout)
  l <- do.call(layout, list(g4))
  plot(g4, edge.arrow.mode=0, layout=l, main=layout, vertex.color=c( "yellow", "skyblue")[1+(V(g4)$part=="student")],vertex.label=NA) }


#par(bg="white")
plot(g4, 
     
     # === vertex
     vertex.color = rgb(0.8,0.4,0.3,0.8),          
     vertex.frame.color = "white",                 
     vertex.shape="circle",                        # One of “none”, “circle”, “square”, “csquare”, “rectangle” “crectangle”, “vrectangle”, “pie”, “raster”, or “sphere”
     vertex.size=5,                               
     vertex.size2=NA,                              
     
     # === vertex label
     vertex.label.color="white",
     vertex.label.family="Times",                  
     vertex.label.font=0.05,                       
     vertex.label.cex=1,                          
     vertex.label.dist=0,                          
     vertex.label.degree=0 ,                      
     
     # === Edge
     edge.color="white",                           
     edge.width=1,                                 
     edge.arrow.size=0.1,                           
     edge.arrow.width=0.1,                         
     edge.lty="solid",                             # Line type, could be 0 or “blank”, 1 or “solid”, 2 or “dashed”, 3 or “dotted”, 4 or “dotdash”, 5 or “longdash”, 6 or “twodash”
     edge.curved=0.1    ,                         
)

deg <- degree(g4, mode="all")
plot(g4, vertex.size=deg*3, edge.arrow.size=.05, vertex.label.color="black", vertex.label.dist=0.1,vertex.size=6,vertex.label.cex=0.8, vertex.color=c( "yellow", "skyblue")[1+(V(g4)$part=="student")])


deg.dist <- degree_distribution(g4, cumulative=T, mode="all")
plot( x=0:max(deg), y=1-deg.dist, pch=19, cex=1.2, col="orange", 
      xlab="Degree", ylab="Cumulative Frequency")


ceb <- cluster_edge_betweenness(g4) 
dendPlot(ceb, mode="hclust")
plot(ceb, g4, edge.arrow.size=.2, vertex.label.color="black", vertex.label.dist=0.1,vertex.size=6,vertex.label.cex=0.8)

