# Statistics for Management and Economics by Gerald Keller
# Chapter 13: INFERENCE ABOUT COMPARING TWO POPULATIONS
# Example 13.10 on Pg 501
# Test Marketing of Package Designs, Part 2

#Aim is to compare two population proportions, brightly colored design (p1) and simple green design (p2)

data1 <- read.csv(file.choose()) #choose Xm13-09.csv
names(data1)

soap1 <- data1$Supermarket.1
soap2 <- data1$Supermarket.2

#Counting the number of successes i.e., number of 9077 brand in both samples
code9077_1 <- length(which(soap1 == 9077)) #Answer: 180
code9077_2 <- length(which(soap2 == 9077)) #Answer: 155

n1 <- length(soap1) #Answer: 904
n2 <- length(soap2) #Answer: 1038

#Comparing two population proportions with hypothesized difference of 3% 
#i.e., two-sample Z test using prop.test() function
chitest <-prop.test(c(180,155),c(904,1038), correct = FALSE)

p1 = chitest$estimate[1] #proportion of brightly colored design
p2 = chitest$estimate[2] #proportion of simple green design

SE = sqrt((p1*(1-p1)/904 + p2*(1-p2)/1038))
z_stat = ((p1 - p2) - 0.03)/SE #0.03 is the hypothesized difference
#Answer: 1.15
p_value = 1 - pnorm(abs(z_stat)) 
#Answer: 0.126

#there is not enough evidence to say that the proportion of soap customers who buy the product with the brightly colored design 
#is more than 3% higher than the proportion of soap customers who buy the product with the simple design.

#End