# Statistics for Management and Economics by Gerald Keller
# Chapter 12: INFERENCE ABOUT A POPULATION
# Example 12.2 on Pg. 403
# Tax Collected from Audited Returns 

data1 <- read.csv(file.choose()) #choose Xm12-02.csv
names(data1)
head(data1)

#One-sample t-test (two-sided) (print confidence interval)
result <- t.test(data1$Taxes, alternative="two.sided", conf.level=0.95)
#Answer: Confidence Interval in $: (8887, 10168)

cat("The Confidence Interval:", "(",round(result$conf.int[1]),",",round(result$conf.int[2]),")")

#Answer is different from the book ($10703,$11983) because dataset is slightly different in the book 
#as compared to the dataset in the website.  
#Mean(dataset given in book) = 11343; sample size(dataset given in book) = 184
#Mean(dataset given in website) = 9527; sample size(dataset given in website) = 192
#End
