# Statistics for Management and Economics by Gerald Keller
# Chapter 13: INFERENCE ABOUT COMPARING TWO POPULATIONS
# Example 13.9 on Pg 499
# Test Marketing of Package Designs, Part 1 

#Aim is to compare two population proportions, brightly colored design and simple green design.

data1 <- read.csv(file.choose()) #choose Xm13-09.csv
names(data1)

soap1 <- data1$Supermarket.1
soap2 <- data1$Supermarket.2

#Counting the number of successes i.e., number of 9077 brand in both samples
code9077_1 <- length(which(soap1 == 9077)) #Answer: 180
code9077_2 <- length(which(soap2 == 9077)) #Answer: 155

#the function length(x[is.na(x)]) gives the number of elements in R object ignoring the NAs
n1 <- length(soap1[!is.na(soap1)]) #Answer: 904
n2 <- length(soap2[!is.na(soap2)]) #Answer: 1038

#Comparing two population proportions i.e., two-sample Z test using prop.test() function
chitest <-prop.test(c(code9077_1,code9077_2),c(n1,n2), correct = FALSE)

#square root of Chi-squared statistic gives the Z-statistic
Z_statistic <- sqrt(chitest$statistic) #Answer: 2.8967 i.e., approx 2.90

Z_critical <- qnorm(0.95) #tabulated critical Z-value at 5% level of significance

if(Z_statistic > round(Z_critical,3))
{
  print("Brightly colored design seems more popular than Simple design;it is recommended that simple green design be used.")
} else 
{
  print("Brightly colored design do not seem more popular than Simple design.")
}

#End
