# Statistics for Management and Economics by Gerald Keller
# Chapter 2: Graphical Descriptive Techniques I
# Example 2.4 on Pg 32
# Newspaper Readership Survey 

#Determine whether the two nominal variables are related

data1 <- read.csv(file.choose()) #choose Xm02-04.csv

Occupation <- data1$Occupation
Newspaper <- data1$Newspaper

#draw cross tables
install.packages("gmodels")
library(gmodels) #gives the entire information on frequencies in cross-table form
CrossTable(Occupation, Newspaper) 


#barchart
bp<-barplot(table(Newspaper,Occupation), beside=TRUE, col=c("blue","orange", "purple", "green"),
        xlab="Occupation", main="Chart of Occupation, Newspaper",
        names.arg = c('Blue-collar', 'White-collar', 'Professional'),
        legend.text = c('G&M', 'Post', 'Star', 'Sun'),
        args.legend = list(x=17.5,y=58, bty='o', cex=0.75,  title="Newspaper"))

#text(x=bp,  labels=c("G&M", "Post", "Star", "Sun"), pos=1)

#End
