# Statistics for Management and Economics by Gerald Keller
# Chapter 3: Graphical Descriptive Techniques II
# Example 3.5 on Pg 65
# Price of Gasoline 

data1 <- read.csv(file.choose()) #choose Xm03-05.csv

#renaming and making a new copy of the required variable
Price <- data1$Price.per.Gallon..Cents. 

#Line chart #to be used for interpretation
plot(Price, xlab = 'Index', ylab = 'Price per gallon',
     main='Time series plot of gasoline price per gallon', type='b')
points(Price, col="red", pch=16)

#Interpretation: The gasoline price rose from about $.60 to more than a dollar in the late 1970s, 
#fluctuated between $.90 and $1.50 until 2000, then generally rose with large fluctuations 
#then declined sharply before rallying in the last 10 months.

#End
