# Statistics for Management and Economics by Gerald Keller
# Chapter 4: Numerical Descriptive Techniques
# Example 4.15 on Pg 123
# Comparing Service Times of Fast-Food Restaurants' Drive-Throughs 

data1 <- read.csv(file.choose()) #choose Xm04-15.csv

#renaming variables for convenience
Popeye <- data1$Popeyes
Wendy <- data1$Wendys
McD <- data1$McDonalds
Hardees <- data1$Hardees
JackinBox <- data1$Jack.in.Box

#Boxplot
boxplot(Popeye,Wendy,McD,Hardees,JackinBox,
        main = "Multiple boxplots for comparison of restaurants' service times",
        at = c(1,2,3,4,5),
        names = c("Popeyes","Wendys","McDonalds","Hardees","Jack in Box"), 
        col = c("orange","red", "blue", "yellow", "black"), 
        border = "brown", 
        horizontal = TRUE, 
xlab = "Service Times of Fast-Food Restaurants' Drive-Throughs")

#End
