# Statistics for Management and Economics by Gerald Keller
# Chapter 12: INFERENCE ABOUT A POPULATION
# Example 12.6 on Pg 437
# Segmenting the Breakfast Cereal Market 


data1 <- read.csv(file.choose()) #choose Xm12-06.csv
names(data1)

healthy <- length(which(data1$Group == 1)) #Answer: 269

n=1250 #Given sample size

chitest <- prop.test(healthy, n, p=NULL, correct = FALSE, alternative="two.sided")

lcl <- chitest$conf.int[1] #Answer: 0.1933 
ucl <- chitest$conf.int[2] #Answer: 0.2388

cat("The 95% confidence interval estimate of proportion of Healthy eating Americans: ", 
    "(", round(lcl,4), ",", round(ucl,4), ")")
#Answer: (0.1933, 0.2388)

#Answer is slightly different from the book: (0.1924, 0.2380)

#End
