# Statistics for Management and Economics by Gerald Keller
# Chapter 13: INFERENCE ABOUT COMPARING TWO POPULATIONS
# Example 13.3 on Pg. 472
# Dietary Effects of High-Fiber Breakfast Cereals 


data1 <- read.csv(file.choose()) #choose Xm13-03.csv

consumer <- data1$Consumers
non_consumer <- data1$Nonconsumers

#t-test with unequal variances
t <- t.test(consumer, non_consumer, var.equal = FALSE, alternative = "less")

cat("The t-test statistic,", t$statistic, "is < than", qt(0.95, df=t$parameter)) 
#qt() gives the tabulated t-critical value at specified df and level of significance

if(t$p.value < 0.05)
{
  print("There is sufficient evidence to support the hypothesis that number of calories for lunch by consumers of high-fiber cereal for breakfast is lower than number of calories for lunch by nonconsumers of highfiber cereal for breakfast.")
} else 
{
  print("There is NO sufficient evidence to support the hypothesis that number of calories for lunch by consumers of high-fiber cereal for breakfast is lower than number of calories for lunch by nonconsumers of highfiber cereal for breakfast.")
}

#End