# Statistics for Management and Economics by Gerald Keller
# Chapter 14: ANALYSIS OF VARIANCE
# Example 14.2a on Pg 544
# Comparing the Costs of Repairing Car Bumpers

data1 <- read.csv(file.choose()) #choose Xm14-02.csv
names(data1)

repair_cost <- data1$repair_cost
bumper <- data1$bumper

oneway_anova <- summary(aov(repair_cost~bumper))
#Answer:

#Df Sum Sq Mean Sq F value Pr(>F)  
#bumper       3 150884   50295   4.056 0.0139 *
#Residuals   36 446368   12399  

#Answer: 
#The test statistic is F = 4.056 and the p-value = 0.0139. 
#Hence, there is enough statistical evidence to infer that there are differences between some of the bumpers.

#End