# Statistics for Management and Economics by Gerald Keller
# Chapter 4: Numerical Descriptive Techniques
# Example 4.18 on Pg 136
# Measuring the Strength of the Linear Relationship 

data1 <- read.csv(file.choose()) #choose Xm04-17.csv

options(digits=5) #for decimal control

Elec_costs <- data1$Electrical.costs #response variable
tool <- data1$Number.of.tools #independent variable

correlation <- cor(Elec_costs, tool)

cat("The correlation coefficient between Electricity Cost and Number of Tools:", correlation)
    
#Answer: 0.87108
#Answer in the book is slightly different: 0.8705

#End