# Statistics for Management and Economics by Gerald Keller
# Chapter 12: INFERENCE ABOUT A POPULATION
# Example 12.5 on Pg 423
# Election Day Exit Poll 

data1 <- read.csv(file.choose()) #choose Xm12-05.csv
names(data1)

democrat <- length(which(data1$Votes == 1)) #Answer: 358
republican <- length(which(data1$Votes == 2)) #Answer: 407

#Success is defined as number of votes cast for the Republican

n=length(data1$Votes) #Given sample size = 765

#One-sample proportion Z Test using prop.test() function
#success probability as per the Null: p=0.5
#one-sided test
#no continuity correction
chitest <- prop.test(republican, n, p=0.5, alternative="greater", correct = FALSE)

#square root of Chi-squared statistic gives the Z-statistic
Z_statistic <- sqrt(chitest$statistic) #Answer: 1.771599 i.e., approx 1.77

Z_critical <- qnorm(0.95) #tabulated critical Z-value at 5% level of significance

cat("There is enough evidence at the 5% significance level that the Republican candidate has won; 
    since", "Z test statistic",Z_statistic, ">", round(Z_critical,3))
cat("And the p-value is < 0.05:", round(chitest$p.value,4)) #Answer: p-value = 0.03823059

#End