# Statistics for Management and Economics by Gerald Keller
# Chapter 3: Graphical Descriptive Techniques II
# Example 3.2 on Pg 52
# Comparing Returns on Two Investments 

data1 <- read.csv(file.choose()) #choose Xm03-02.csv

par(mfrow=c(1,2))
#Histogram of ROI on A
hist(data1$Return.A, labels = TRUE, xlab = "ROI on A", xaxt='n', yaxt='n',
     main = 'Returns on Investment A', breaks=seq(-30, 75, l=8))
axis(side=1, at=seq(-30,75,15))
axis(side=2, at=seq(0,18,2))

#Histogram of ROI on B
hist(data1$Return.B, labels = TRUE, xlab = "ROI on B", xaxt='n', yaxt='n',
     main = 'Returns on Investment B', breaks=seq(-45, 75, l=9))
axis(side=1, at=seq(-30,75,15))
axis(side=2, at=seq(0,18,2))

#use both Histograms to compare which of A or B is better for investment.

#End