# Statistics for Management and Economics by Gerald Keller
# Chapter 13: INFERENCE ABOUT COMPARING TWO POPULATIONS
# Example 13.7 on Pg 491
# Testing the Quality of Two-Bottle Filling Machines 

data1 <- read.csv(file.choose()) #choose Xm13-07.csv
names(data1)

Machine_1 <- data1$Machine.1
Machine_2 <- data1$Machine.2

#F-test for variances using var.test() function
var.test(Machine_1, Machine_2, alternative = "two.sided")
#Answer:
#F test to compare two variances

#data:  Machine_1 and Machine_2
#F = 1.3988, num df = 24, denom df = 24, p-value = 0.417
#alternative hypothesis: true ratio of variances is not equal to 1
#95 percent confidence interval: (0.6164109, 3.1742817)
#sample estimates:  ratio of variances 1.398807

#End