# Statistics for Management and Economics by Gerald Keller
# Chapter 13: INFERENCE ABOUT COMPARING TWO POPULATIONS
# Example 13.6 on Pg. 482
# Comparing Salary Offers for Finance and Marketing MBA Majors, Part 3 


data1 <- read.csv(file.choose()) #choose Xm13-05.csv

finance <- data1$Finance
marketing <- data1$Marketing

#paired t-test using the paired=TRUE in function t.test() 

t <- t.test(finance, marketing, paired = TRUE, alternative = "two.sided")
lcl = t$conf.int[1]
ucl = t$conf.int[2]
cat("The 95% confidence interval estimate of p1 - p2: ", "(", round(lcl,0), ",", round(ucl,0), ")")

#End
