# Statistics for Management and Economics by Gerald Keller
# Chapter 14: ANALYSIS OF VARIANCE
# Example 14.3 on Pg 557
# Comparing Cholesterol-Lowering Drugs

data1 <- read.csv(file.choose()) #choose Xm14-03.csv
names(data1)
head(data1)

cholesterol <- data1$cholesterol
drug <- as.character(data1$drug)
grp <- as.character(data1$group)
class(drug) #Answer: "character"
class(grp) #Answer: "character"
#as.character() function converts the variable from integer to character variable.
#class() function helps in checking the type of a variable.

#Two-way ANOVA based on Factors (Drug, Group)
twoway_anova <- summary(aov(cholesterol~drug+grp))
#Answer: The F-statistic for Drug is 4.12 with a p-value of .009. 
#        The F-statistic for the blocks (Group) is 10.11, with a p-value of 0.
# we conclude that there is sufficient evidence to infer that at least two of the drugs differ. 

#End
